"""
Passenger WSGI entry point for cPanel / Namecheap shared hosting.
Exposes the FastAPI (ASGI) app as WSGI so Passenger can run it.
"""
import os
import sys
import traceback

# Application root = directory containing this file (same folder as main.py, app/)
app_root = os.path.dirname(os.path.abspath(__file__))
sys.path.insert(0, app_root)

# Load .env before importing the app (so config sees the variables)
try:
    from dotenv import load_dotenv
    env_path = os.path.join(app_root, ".env")
    if os.path.isfile(env_path):
        load_dotenv(dotenv_path=env_path)
except Exception:
    pass

# Import the FastAPI app; on failure expose error as WSGI response so you can see it in the browser
try:
    from app.main import app
    from a2wsgi import ASGIMiddleware
    application = ASGIMiddleware(app)
except Exception as e:
    err_msg = traceback.format_exc()
    def application(environ, start_response):
        start_response("500 Internal Server Error", [("Content-Type", "text/plain; charset=utf-8")])
        return [("Application failed to start:\n\n" + err_msg).encode("utf-8")]
