-- Add approval/rejection columns to `data` table.
-- These are set only by the approval/rejection API; the batch submit API does not insert into them.
-- Run each statement; if a column already exists, that statement will error (safe to skip).

ALTER TABLE `data` ADD COLUMN `analyst_approved_by` varchar(255) DEFAULT NULL COMMENT 'Email of analyst who approved';
ALTER TABLE `data` ADD COLUMN `analyst_approved_at` datetime DEFAULT NULL COMMENT 'Timestamp when analyst approved';
ALTER TABLE `data` ADD COLUMN `tl_approved_by` varchar(255) DEFAULT NULL COMMENT 'Email of team lead who approved';
ALTER TABLE `data` ADD COLUMN `tl_approved_at` datetime DEFAULT NULL COMMENT 'Timestamp when team lead approved';
ALTER TABLE `data` ADD COLUMN `analyst_rejected_by` varchar(255) DEFAULT NULL COMMENT 'Email of analyst who rejected';
ALTER TABLE `data` ADD COLUMN `analyst_rejected_at` datetime DEFAULT NULL COMMENT 'Timestamp when analyst rejected';
ALTER TABLE `data` ADD COLUMN `analyst_rejection_reason` text DEFAULT NULL COMMENT 'Reason for analyst rejection';
ALTER TABLE `data` ADD COLUMN `tl_rejected_by` varchar(255) DEFAULT NULL COMMENT 'Email of team lead who rejected';
ALTER TABLE `data` ADD COLUMN `tl_rejected_at` datetime DEFAULT NULL COMMENT 'Timestamp when team lead rejected';
ALTER TABLE `data` ADD COLUMN `tl_rejection_reason` text DEFAULT NULL COMMENT 'Reason for team lead rejection';
