# Production .env Checklist (unilever.mobilitysolutions-ke.com)

Use this when setting `backend/.env` on the server.

---

## Domains

| Role      | URL |
|-----------|-----|
| Frontend  | http://unilever.mobilitysolutions-ke.com |
| Backend   | http://api.unilever.mobilitysolutions-ke.com |

---

## What you MUST change in `backend/.env`

| Variable | Set to |
|----------|--------|
| **DEBUG** | `false` |
| **DB_HOST** | Your MySQL host (e.g. `localhost` if DB is on same server, or the remote host) |
| **DB_USER** | DB username |
| **DB_PASSWORD** | DB password |
| **DB_NAME** | Database name (e.g. `bt`) |
| **JWT_SECRET_KEY** | New secret, at least 32 characters |
| **CORS_ORIGINS** | Frontend + API URLs so `/docs` and "Try it out" work (comma-separated, no spaces after comma): `http://unilever.mobilitysolutions-ke.com,https://unilever.mobilitysolutions-ke.com,http://api.unilever.mobilitysolutions-ke.com,https://api.unilever.mobilitysolutions-ke.com` |
| **BASE_URL** | `http://api.unilever.mobilitysolutions-ke.com` |
| **FRONTEND_URL** | `http://unilever.mobilitysolutions-ke.com` |
| **LOGIN_URL** | `http://unilever.mobilitysolutions-ke.com/login` |
| **MAIL_DEBUG** | `false` |
| **SMTP_DEBUG** | `false` |
| **SMTP_PASSWORD** | Your real SMTP password (if using email) |

---

## Database

- **If the DB stays on the same server as the API:** set `DB_HOST=localhost` and use the same or a new DB user/password/name.
- **If the DB is on another server (e.g. managed MySQL):** set `DB_HOST` to that host, and use the credentials they give you for `DB_USER`, `DB_PASSWORD`, `DB_NAME`, and `DB_PORT` if different from 3306.

So yes: you do need to set DB_* (and the rest above) in `.env` for production; the exact DB_* values depend on where your production MySQL runs.

---

## Accessing `/docs` (Swagger UI)

The `/docs` page is served by the API. If you open **https://api.unilever.mobilitysolutions-ke.com/docs** in the browser, the page and "Try it out" requests use the **API origin** (`https://api.unilever.mobilitysolutions-ke.com`). CORS must allow that origin.

**In `.env` set CORS_ORIGINS to include both frontend and API URLs** (comma-separated):

```env
CORS_ORIGINS=http://unilever.mobilitysolutions-ke.com,https://unilever.mobilitysolutions-ke.com,http://api.unilever.mobilitysolutions-ke.com,https://api.unilever.mobilitysolutions-ke.com
```

Or, for development only, you can use `CORS_ORIGINS=*` to allow all origins (less secure for production).

---

## .env format (important)

- **Do not put production credentials in `config.py`.** Keep them only in `.env` or cPanel environment variables.
- **Quote values that contain special characters** (`@`, `$`, `%`, `#`, spaces) so they are read correctly:
  ```env
  DB_PASSWORD="YKlKF@hB^5$@pfKa"
  SMTP_PASSWORD="9s4I3%Ho$Z2MPOJa"
  ```
- **JWT_SECRET_KEY** must be at least 32 characters. Replace the placeholder with a real secret for production (e.g. `openssl rand -base64 32`).

---

## Frontend build

Before deploying the admin app, build it with the production API URL:

- Create `frontend/admin/.env.production` with:
  ```env
  VITE_API_BASE_URL=http://api.unilever.mobilitysolutions-ke.com/api/v1
  ```
- Run: `npm run build`
- Deploy the contents of `dist/` to the server serving **http://unilever.mobilitysolutions-ke.com**

---

## Reference

- Full example: `backend/.env.production.example`
